/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.mysql;

import com.sigge.dbrunner.ADatabase;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.mysql.MySQLDatabaseOperator;
import com.sigge.dbrunner.mysql.MySQLScriptRunner;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class MySQLDatabase
extends ADatabase<MySQLScriptRunner> {
    private static final String ALLOW_MULTI_QUERIES_TRUE = "allowMultiQueries=true";
    public static final String PROVIDER_NAME = "MYSQL";
    private final DatabaseServerConfig config;
    private final String label;

    public MySQLDatabase(DatabaseServerConfig config) {
        this.config = config;
        this.label = config.getServerLabel();
    }

    @Override
    public String getDatabaseProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public String getServer() {
        return this.config.getServer();
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    @Override
    public boolean isUseAD() {
        return false;
    }

    @Override
    public String getUniqueProviderName() {
        return String.valueOf(this.config.getUrl() != null && this.config.getUrl().length() > 0 ? this.config.getUrl() : String.valueOf(this.getUser()) + "@" + this.getServer()) + "/" + (this.label != null ? this.label : "");
    }

    public String toString() {
        return String.valueOf(this.getUser()) + "@" + this.getServer();
    }

    @Override
    protected MySQLScriptRunner createScriptRunner(String databaseName) throws SQLException {
        return new MySQLScriptRunner(this.createConnection(databaseName, null), this);
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        String url = this.config.getUrl();
        if (url != null && url.length() > 0) {
            if (!url.toLowerCase().contains(ALLOW_MULTI_QUERIES_TRUE)) {
                url = !url.contains("?") ? String.valueOf(url) + "?" + ALLOW_MULTI_QUERIES_TRUE : String.valueOf(url) + "&" + ALLOW_MULTI_QUERIES_TRUE;
            }
            Connection c = DriverManager.getConnection(url);
            if (database != null && database.length() > 0) {
                c.setCatalog(database);
            }
            return c;
        }
        return DriverManager.getConnection(this.generateConnectionString(database), this.config.getUser(), this.config.getPassword());
    }

    @Override
    public String getServerLabel() {
        return this.label;
    }

    private String generateConnectionString(String database) {
        StringBuilder sb = new StringBuilder("jdbc:mysql://").append(this.config.getServer());
        if (!database.isEmpty()) {
            sb.append("/").append(database);
        }
        sb.append("?");
        sb.append(ALLOW_MULTI_QUERIES_TRUE);
        return sb.toString();
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return new MySQLDatabaseOperator(this);
    }

    @Override
    public String getConnectionUrl() {
        return this.config.getUrl() != null && this.config.getUrl().length() > 0 ? this.config.getUrl() : this.generateConnectionString("");
    }
}

