/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.jdbc;

import com.sigge.dbrunner.ADatabase;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.jdbc.JDBCDatabaseOperator;
import com.sigge.dbrunner.jdbc.JDBCScriptRunner;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class JDBCDatabase
extends ADatabase<JDBCScriptRunner> {
    public static final String PROVIDER_NAME = "JDBC";
    private final DatabaseServerConfig config;
    private final String label;

    public JDBCDatabase(DatabaseServerConfig config) {
        this.config = config;
        this.label = config.getServerLabel();
    }

    @Override
    public String getDatabaseProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public String getServer() {
        return this.config.getServer();
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    @Override
    public boolean isUseAD() {
        return false;
    }

    @Override
    public String getUniqueProviderName() {
        return String.valueOf(this.config.getUrl()) + "/" + (this.label != null ? this.label : "");
    }

    public String toString() {
        return this.config.getUrl();
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        Connection c = DriverManager.getConnection(this.config.getUrl());
        if (database != null && database.length() > 0) {
            c.setCatalog(database);
        }
        return c;
    }

    @Override
    protected JDBCScriptRunner createScriptRunner(String databaseName) throws SQLException {
        return new JDBCScriptRunner(this.createConnection(databaseName, null), this);
    }

    @Override
    public String getServerLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return new JDBCDatabaseOperator(this);
    }

    @Override
    public String getConnectionUrl() {
        return this.getUrl();
    }
}

