/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.NewLineReader;
import com.sigge.dbrunner.SQLOptions;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public abstract class AScriptRunner<E extends Database>
implements IScriptRunner {
    protected static final String DEFAULT_DELIMITER = ";";
    protected boolean autoCommit;
    protected boolean sendFullScript;
    protected String delimiter = ";";
    protected boolean fullLineDelimiter = false;
    private volatile boolean disposed = false;
    protected Connection connection;
    protected final E database;
    protected String currentDatabase;

    public AScriptRunner(Connection connection, E database) {
        this.connection = connection;
        this.database = database;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setSendFullScript(boolean sendFullScript) {
        this.sendFullScript = sendFullScript;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFullLineDelimiter(boolean fullLineDelimiter) {
        this.fullLineDelimiter = fullLineDelimiter;
    }

    @Override
    public void runScript(Reader reader, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, Exception {
        this.currentDatabase = null;
        if (options.isCancelled()) {
            return;
        }
        this.setAutoCommit();
        try {
            if (this.sendFullScript) {
                this.executeFullScript(reader, reporter, options);
            } else {
                this.executeByBatches(reader, reporter, options);
            }
        }
        finally {
            this.rollbackConnection(options);
        }
    }

    @Override
    public boolean isAlive() {
        try {
            boolean isAlive = !this.connection.isClosed() && this.connection.isValid(1);
            return isAlive;
        }
        catch (SQLException e) {
            return false;
        }
        catch (Throwable tex) {
            block15: {
                Throwable throwable = null;
                Object var3_7 = null;
                Statement stmt = this.connection.createStatement();
                try {
                    stmt.setQueryTimeout(1);
                    stmt.executeQuery("SELECT 1");
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        return false;
                    }
                }
                stmt.close();
            }
            return true;
        }
    }

    @Override
    public void changeDatabase(String database) throws SQLException {
        this.connection.setCatalog(database);
        this.currentDatabase = database;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public String getCurrentDatabase() throws SQLException {
        if (this.currentDatabase == null) {
            this.currentDatabase = this.connection.getCatalog();
        }
        if (this.currentDatabase == null) {
            this.currentDatabase = "(default)";
        }
        return this.currentDatabase;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public ResultSet executeQuery(String command) throws SQLException {
        this.currentDatabase = null;
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(command);
    }

    private void executeFullScript(Reader reader, List<IProgressReporter> reporter, SQLOptions options) throws SQLException {
        StringBuilder script = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (NewLineReader lineReader = new NewLineReader(reader);){
                String line;
                int cnt = 0;
                while ((line = lineReader.readLine()) != null) {
                    if (++cnt % 1000 == 0 && options.isCancelled()) {
                        return;
                    }
                    script.append(lineReader.getPreNewLine());
                    script.append(line);
                    script.append(lineReader.getPostNewLine());
                }
                script.append(lineReader.getPreNewLine());
                script.append(lineReader.getPostNewLine());
                if (options.isCancelled()) {
                    return;
                }
                options.setCurrentBatchLineStart(0);
                this.executeStatement(script.toString(), reporter, options);
                this.commitConnection();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Error executing: " + script + ".  Cause: " + e;
            throw new RuntimeException(message, e);
        }
    }

    protected void executeByBatches(Reader reader, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, UnsupportedEncodingException, IOException {
        String line;
        StringBuilder command = new StringBuilder();
        NewLineReader lineReader = new NewLineReader(reader);
        options.setCurrentBatchLineStart(1);
        while ((line = lineReader.readLine()) != null) {
            command = this.handleLine(command, lineReader, line, reporter, options);
        }
        if (command != null) {
            command.append(lineReader.getPreNewLine());
            command.append(lineReader.getPostNewLine());
            String lastSQL = command.toString();
            if (lastSQL.trim().length() > 0) {
                this.executeStatement(lastSQL, reporter, options);
            }
        }
        this.commitConnection();
    }

    @Override
    public void closeConnection() {
        try {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                this.currentDatabase = null;
            }
        }
        finally {
            this.currentDatabase = null;
        }
    }

    private void setAutoCommit() {
        try {
            if (this.autoCommit != this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(this.autoCommit);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not set AutoCommit to " + this.autoCommit + ". Cause: " + t, t);
        }
    }

    private void commitConnection() {
        try {
            try {
                if (!this.connection.isClosed() && !this.connection.getAutoCommit()) {
                    this.connection.commit();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not commit transaction. Cause: " + t, t);
            }
        }
        finally {
            this.currentDatabase = null;
        }
    }

    private void rollbackConnection(SQLOptions options) {
        try {
            try {
                if (!this.connection.isClosed() && !this.connection.getAutoCommit() && options.isRollbackAllUncommitedTransactions()) {
                    this.connection.rollback();
                }
            }
            catch (Throwable throwable) {
                this.currentDatabase = null;
            }
        }
        finally {
            this.currentDatabase = null;
        }
    }

    private StringBuilder handleLine(StringBuilder command, NewLineReader lineReader, String line, List<IProgressReporter> reporter, SQLOptions options) throws SQLException {
        String preNewLine = lineReader.getPreNewLine();
        String postNewLine = lineReader.getPostNewLine();
        options.setCurrentBatchLineEnd(options.getCurrentBatchLineEnd() + 1);
        if (this.commandReadyToExecute(line)) {
            command.append(preNewLine);
            command.append(line.substring(0, line.toUpperCase().lastIndexOf(this.delimiter)));
            command.append(postNewLine);
            boolean executeStatement = this.executeStatement(command.toString(), reporter, options);
            options.setCurrentBatchLineStart(options.getCurrentBatchLineEnd());
            if (executeStatement) {
                return null;
            }
            command.setLength(0);
        } else {
            command.append(preNewLine);
            command.append(line);
            command.append(postNewLine);
        }
        return command;
    }

    private boolean commandReadyToExecute(String line) {
        return !this.fullLineDelimiter && line.trim().toUpperCase().endsWith(this.delimiter) || this.fullLineDelimiter && line.trim().equalsIgnoreCase(this.delimiter);
    }

    protected boolean executeStatement(String command, List<IProgressReporter> reporter, SQLOptions options) throws SQLException {
        Statement statement = options.getStatementConsumer() != null ? this.connection.prepareStatement(command, 1003, 1007) : this.connection.createStatement(1003, 1007);
        String c = command;
        reporter.stream().forEach(l -> l.reportScriptStarted(c, statement));
        if (options.isCancelled() || this.disposed) {
            reporter.stream().forEach(l -> l.reportCancelled());
            this.closeStatement(statement);
            return true;
        }
        boolean result = true;
        boolean wasError = false;
        try {
            if (options.getTimeout() > 0) {
                statement.setQueryTimeout(options.getTimeout());
            }
            result = this.runCommand(command, options, statement);
        }
        catch (SQLException e) {
            wasError = true;
            if (reporter.size() > 0) {
                boolean resultDuringException = result;
                reporter.stream().forEach(l -> l.reportScriptFailure(c, statement, e, resultDuringException));
            }
            throw e;
        }
        if (reporter.size() > 0) {
            boolean resultDuringException = result;
            reporter.stream().forEach(l -> l.reportScriptFinished(c, statement, resultDuringException));
        }
        this.closeStatement(statement);
        return options.isStopBatchesAtFirstError() && wasError;
    }

    protected abstract boolean runCommand(String var1, SQLOptions var2, Statement var3) throws SQLException;

    private void closeStatement(Statement statement) {
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

