/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view;

import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingRunnable;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import com.siggemannen.view.IBackgroundExecutorHandler;
import com.siggemannen.view.ICompletionProgress;
import com.siggemannen.view.IStatusProgress;
import com.siggemannen.view.UIBackgroundDialog;
import com.siggemannen.view.UIOptionBuilderRunnable;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionCommon;
import com.siggemannen.view.UIOptionRunnable;
import com.siggemannen.view.UIOptionSupplier;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class UIBackgroundRunner {
    static final ThrowingRunnable CALLBACK_SINK = () -> {};
    static final ThrowingConsumer<Exception> EXCEPTION_SINK = e -> e.printStackTrace();

    private UIBackgroundRunner() {
    }

    public static <T> void execute(RootPaneContainer f, ThrowingSupplier<T> supplier, ThrowingConsumer<T> callback) {
        UIBackgroundRunner.execute(f, supplier, callback, EXCEPTION_SINK, CALLBACK_SINK, "Performing operation...", "System is busy. You can cancel it by using the cancel button", "Cancel");
    }

    public static <T> void execute(RootPaneContainer f, ThrowingSupplier<T> supplier, ThrowingConsumer<T> callback, ThrowingConsumer<Exception> exceptionConsumer, ThrowingRunnable cancellationCallback) {
        UIBackgroundRunner.execute(f, supplier, callback, exceptionConsumer, cancellationCallback, "Performing operation...", "System is busy. You can cancel it by using the cancel button", "Cancel");
    }

    public static <T> void execute(RootPaneContainer f, ThrowingSupplier<T> supplier, ThrowingConsumer<T> callback, ThrowingConsumer<Exception> exceptionConsumer, String titleMessage, String busyMessage, String cancelMessage) {
        UIBackgroundRunner.execute(f, supplier, callback, exceptionConsumer, CALLBACK_SINK, titleMessage, busyMessage, cancelMessage);
    }

    public static <T> void execute(RootPaneContainer f, ThrowingSupplier<T> supplier, ThrowingConsumer<T> callback, ThrowingConsumer<Exception> exceptionConsumer, ThrowingRunnable cancellationCallback, String titleMessage, String busyMessage, String cancelMessage) {
        UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier<T>(supplier, callback).mainPanel(f)).cancellationCallback(cancellationCallback)).exceptionCallback((ThrowingConsumer)exceptionConsumer)).title(titleMessage, busyMessage, cancelMessage)).build());
    }

    public static <T> void execute(UIOptionSupplier<T> options) {
        Executor<T> x = new Executor<T>(options.getSupplier());
        new BackgroundRunner(() -> Executor.access$0(x), options.getCallback(), options.getExceptionCallback()).execute();
        UIBackgroundRunner.ui(x, options);
    }

    private static <T> void createCompletionProgress(final UIOptionCommon options, final UIBackgroundDialog ud) {
        ICompletionProgress icp = new ICompletionProgress(){
            private volatile boolean cancel;
            private final List<ICompletionProgress> listeners = new ArrayList<ICompletionProgress>();

            @Override
            public void cancel() {
                this.cancel = true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancel;
            }

            @Override
            public void status(int percentage, String message, Exception ex) {
                SwingUtilities.invokeLater(() -> {
                    ud.setTitle(String.valueOf(options.getTitle()) + " - " + message);
                    uIBackgroundDialog.progressBar.setValue(percentage);
                    uIBackgroundDialog.waitingMessageLabel.setText(message);
                    uIBackgroundDialog.progressBar.setToolTipText(message);
                    for (ICompletionProgress progress : this.listeners) {
                        try {
                            progress.status(percentage, message, ex);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                });
            }

            @Override
            public void addListener(ICompletionProgress progress) {
                this.listeners.add(progress);
            }

            @Override
            public void removeListener(ICompletionProgress progress) {
                this.listeners.remove(progress);
            }
        };
        options.comp.setProgress(icp);
    }

    private static <T> void createProgress(UIOptionCommon options, final UIBackgroundDialog ud) {
        IStatusProgress icp = new IStatusProgress(){
            private volatile boolean cancel;
            private final List<IStatusProgress> listeners = new ArrayList<IStatusProgress>();

            @Override
            public void cancel() {
                this.cancel = true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancel;
            }

            @Override
            public void status(String message, Optional<Exception> ex) {
                SwingUtilities.invokeLater(() -> {
                    uIBackgroundDialog.progressBar.setString(message);
                    for (IStatusProgress progress : this.listeners) {
                        try {
                            progress.status(message, ex);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            @Override
            public void addListener(IStatusProgress progress) {
                this.listeners.add(progress);
            }

            @Override
            public void removeListener(IStatusProgress progress) {
                this.listeners.remove(progress);
            }
        };
        options.status.setProgress(icp);
    }

    private static String wrapInHTML(String string) {
        if (string.contains("<html>")) {
            return string;
        }
        return "<html>" + string + "</html>";
    }

    public static void execute(ThrowingRunnable task) {
        UIBackgroundRunner.execute((UIOptionRunnable)new UIOptionBuilderRunnable(task).build());
    }

    public static void execute(RootPaneContainer f, ThrowingRunnable task) {
        UIBackgroundRunner.execute((UIOptionRunnable)((UIOptionBuilderRunnable)new UIOptionBuilderRunnable(task).mainPanel(f)).build());
    }

    public static void execute(RootPaneContainer f, ThrowingRunnable task, String title, String busyMessage, String cancelMessage) {
        UIBackgroundRunner.execute((UIOptionRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)new UIOptionBuilderRunnable(task).mainPanel(f)).title(title, busyMessage, cancelMessage)).build());
    }

    public static void execute(UIOptionRunnable runnable) {
        Executor x = new Executor(runnable.getRunnable());
        new BackgroundRunner(() -> Executor.access$0(x), runnable.getCallback(), runnable.getExceptionCallback()).execute();
        UIBackgroundRunner.ui(x, runnable);
    }

    private static <T> void ui(Executor<T> x, UIOptionCommon options) {
        int i;
        Component glassPane;
        int i2 = 0;
        while (i2 < 5) {
            if (x.finished) {
                return;
            }
            UIBackgroundRunner.sleep(50);
            ++i2;
        }
        Component component = glassPane = options.getFrame() == null ? null : options.getFrame().getGlassPane();
        if (glassPane != null) {
            UIBackgroundRunner.invokeAndWait(() -> glassPane.setVisible(true));
            i = 0;
            while (i < 5) {
                if (x.finished) {
                    glassPane.setVisible(false);
                    glassPane.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                UIBackgroundRunner.sleep(50);
                ++i;
            }
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            i = 0;
            while (i < 5) {
                if (x.finished) {
                    return;
                }
                UIBackgroundRunner.sleep(50);
                ++i;
            }
        }
        UIBackgroundDialog ud = new UIBackgroundDialog(options.getFrame() instanceof Frame ? (Frame)((Object)options.getFrame()) : null, true);
        if (options.getDialogIcon() != null) {
            ud.setIconImage(options.getDialogIcon());
        }
        ud.setTitle(options.getTitle());
        if (options.getCompletionProgress() != null) {
            ud.progressBar.setIndeterminate(false);
            ud.progressBar.setMinimum(0);
            ud.progressBar.setMaximum(100);
            ud.progressBar.setStringPainted(true);
            ud.progressBar.setVisible(true);
            UIBackgroundRunner.createCompletionProgress(options, ud);
        } else if (options.getProgress() != null) {
            ud.progressBar.setIndeterminate(true);
            ud.progressBar.setStringPainted(true);
            ud.progressBar.setString("");
            ud.progressBar.setVisible(true);
            UIBackgroundRunner.createProgress(options, ud);
        }
        ud.cancelButton.setText(options.getCancelMessage());
        ud.setLocationRelativeTo(null);
        ud.setReturnStatus(1);
        if (ud.progressBar.isVisible()) {
            ud.waitingMessageLabel.setVisible(false);
            ud.busyLabel.setVisible(false);
        } else {
            ud.waitingMessageLabel.setText(UIBackgroundRunner.wrapInHTML(options.getBusyMessage()));
            ud.busyLabel.setBusy(true);
        }
        BackgroundRunner br = new BackgroundRunner(() -> UIBackgroundRunner.whileSleep(x, ud, options.getCancellationCallback()));
        if (options.backgroundHandler != null) {
            IBackgroundExecutorHandler createBackgroundExecutor = UIBackgroundRunner.createBackgroundExecutor(x, options, glassPane, ud, br);
            options.backgroundHandler.accept(createBackgroundExecutor);
            ud.backgroundButton.setVisible(true);
            if (options.getBackgroundStringTitle() != null) {
                ud.backgroundButton.setText(options.getBackgroundStringTitle());
            }
            ud.backgroundButton.addActionListener(l -> createBackgroundExecutor.toBackground());
        }
        br.execute();
        ud.pack();
        if (!x.finished) {
            ud.setVisible(true);
        } else {
            ud.setReturnStatus(1);
        }
        UIBackgroundRunner.finish(x, options, glassPane, ud, br);
    }

    private static <T> IBackgroundExecutorHandler createBackgroundExecutor(final Executor<T> x, final UIOptionCommon options, final Component glassPane, final UIBackgroundDialog ud, final BackgroundRunner br) {
        return new IBackgroundExecutorHandler(){
            private boolean inBackground = false;

            @Override
            public void toForeground() {
                this.inBackground = false;
                if (glassPane != null) {
                    glassPane.setCursor(Cursor.getPredefinedCursor(3));
                    glassPane.setVisible(true);
                }
                ud.setReturnStatus(1);
                ud.setVisible(true);
                UIBackgroundRunner.finish(x, options, glassPane, ud, br);
            }

            @Override
            public void toBackground() {
                this.inBackground = true;
                ud.setReturnStatus(2);
                ud.setVisible(false);
                if (glassPane != null) {
                    glassPane.setVisible(false);
                    glassPane.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public boolean isInBackground() {
                return this.inBackground;
            }
        };
    }

    private static <T> void finish(Executor<T> x, UIOptionCommon options, Component glassPane, UIBackgroundDialog ud, BackgroundRunner br) {
        if (ud.getReturnStatus() == 0) {
            options.comp.cancel();
            options.status.cancel();
            if (options.isForceCancel()) {
                try {
                    br.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (ud.getReturnStatus() != 2) {
            ((Executor)x).finished = true;
        }
        if (glassPane != null) {
            glassPane.setVisible(false);
            glassPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static void invokeAndWait(Runnable r) {
        try {
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeAndWait(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void whileSleep(Executor x, UIBackgroundDialog jd, ThrowingRunnable cancellationCallback) {
        while (!x.finished) {
            try {
                x.queue.take();
            }
            catch (InterruptedException e) {
                break;
            }
        }
        jd.setVisible(false);
        if (jd.getReturnStatus() == 0) {
            cancellationCallback.run();
        }
        jd.dispose();
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Executor<T> {
        private volatile boolean finished;
        private final ThrowingSupplier<T> runnable;
        private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);

        Executor(ThrowingRunnable task) {
            this.runnable = () -> {
                try {
                    task.run();
                }
                finally {
                    this.finished = true;
                    this.queue.add(new Object());
                }
                return null;
            };
        }

        Executor(ThrowingSupplier<T> task) {
            this.runnable = () -> {
                Object value = null;
                try {
                    value = task.get();
                }
                finally {
                    this.finished = true;
                    this.queue.add(new Object());
                }
                return value;
            };
        }

        private T run() {
            return (T)this.runnable.get();
        }

        static /* synthetic */ Object access$0(Executor executor) {
            return executor.run();
        }
    }
}

