/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view;

import com.siggemannen.view.ICompletionProgress;
import java.util.ArrayList;
import java.util.List;

class CompletionProgress
implements ICompletionProgress {
    private ICompletionProgress progress = null;
    private boolean cancel = false;
    private final List<ICompletionProgress> listeners = new ArrayList<ICompletionProgress>();
    private String initialStatus = null;
    private int initialPercentage;

    CompletionProgress() {
    }

    @Override
    public void status(int percentage, String message, Exception ex) {
        if (this.progress == null) {
            this.initialStatus = message;
            this.initialPercentage = percentage;
            return;
        }
        this.progress.status(percentage, message, ex);
    }

    void setProgress(ICompletionProgress progress) {
        this.progress = progress;
        this.listeners.forEach(this.progress::addListener);
        if (this.initialStatus != null) {
            progress.status(this.initialPercentage, this.initialStatus);
            this.initialStatus = null;
        }
    }

    @Override
    public void cancel() {
        if (this.progress == null) {
            this.cancel = true;
            return;
        }
        this.progress.cancel();
    }

    @Override
    public boolean isCancelled() {
        if (this.progress == null) {
            return this.cancel;
        }
        return this.progress.isCancelled();
    }

    @Override
    public void addListener(ICompletionProgress listener) {
        if (this.progress == null) {
            this.listeners.add(listener);
            return;
        }
        this.progress.addListener(listener);
    }

    @Override
    public void removeListener(ICompletionProgress listener) {
        if (this.progress == null) {
            this.listeners.remove(listener);
            return;
        }
        this.progress.removeListener(listener);
    }
}

