/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.binding;

import com.siggemannen.binding.AModel;
import com.siggemannen.binding.SelectionChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class APropertyListModel<E>
implements ComboBoxModel<E> {
    private static final Set<Class> boxable = new HashSet<Class>(Arrays.asList(String.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class));
    private final AModel.BoundedListProperty<E> list;
    List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    List<SelectionChangeListener<E>> selectionListeners = new ArrayList<SelectionChangeListener<E>>();
    private E selectedItem;

    public APropertyListModel(AModel.BoundedListProperty<E> list) {
        this.list = list;
        this.selectedItem = null;
    }

    public List<E> getObject() {
        return (List)this.list.getValue();
    }

    private boolean isBoxableEquals(Object anItem) {
        return anItem != null && boxable.contains(anItem.getClass()) && anItem.equals(this.selectedItem);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSelectedItem(Object anItem) {
        void var3_4;
        if (this.selectedItem == anItem || this.isBoxableEquals(anItem)) {
            return;
        }
        this.selectedItem = anItem;
        int index = -1;
        boolean bl = false;
        while (var3_4 < ((List)this.list.getValue()).size()) {
            Object o = ((List)this.list.getValue()).get((int)var3_4);
            if (o == anItem) {
                index = var3_4;
                break;
            }
            ++var3_4;
        }
        if (index == -1) {
            index = ((List)this.list.getValue()).indexOf(anItem);
        }
        this.list.setSelectedItem(anItem);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, index, index));
        }
        for (SelectionChangeListener selectionChangeListener : this.selectionListeners) {
            selectionChangeListener.selectionChanged(this.selectedItem, index);
        }
    }

    public void setSelectedObject(E item) {
        this.setSelectedItem(item);
    }

    @Override
    public E getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return ((List)this.list.getValue()).size();
    }

    @Override
    public E getElementAt(int index) {
        return (E)this.list.getRowAt(index);
    }

    public void addSelectionChangeListener(SelectionChangeListener<E> l) {
        this.selectionListeners.add(l);
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        this.selectionListeners.remove(l);
    }

    public void removeCurrentElement() {
        this.removeElement(this.selectedItem);
    }

    public void moveCurrentElement(boolean up) {
        if (this.selectedItem == null) {
            return;
        }
        int i = ((List)this.list.getValue()).indexOf(this.selectedItem);
        if (i == 0 && up || i == this.list.size() - 1 && !up) {
            return;
        }
        int idxNew = up ? i - 1 : i + 1;
        Object e = this.list.getRowAt(idxNew);
        ((List)this.list.getValue()).set(idxNew, this.selectedItem);
        ((List)this.list.getValue()).set(i, e);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, i, idxNew));
        }
        for (SelectionChangeListener selectionChangeListener : this.selectionListeners) {
            selectionChangeListener.selectionChanged(this.selectedItem, idxNew);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void addElement(E item) {
        this.list.addRow(item);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.intervalAdded(new ListDataEvent(this, 1, this.getSize() - 1, this.getSize() - 1));
        }
    }

    public void removeElement(E obj) {
        int index = ((List)this.list.getValue()).indexOf(obj);
        if (index > -1) {
            this.removeElementAt(index);
        }
    }

    public void insertElementAt(E item, int index) {
        this.list.insertRowAt(item, index);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.intervalAdded(new ListDataEvent(this, 1, index, index));
        }
    }

    public void removeElementAt(int index) {
        Object obj = ((List)this.list.getValue()).get(index);
        boolean remapSelection = false;
        int newIndex = index - 1;
        if (this.selectedItem != null && this.selectedItem.equals(obj)) {
            remapSelection = true;
        }
        this.list.removeObject(obj);
        if (remapSelection) {
            if (newIndex < 0) {
                newIndex = 0;
            }
            if (newIndex >= this.list.size()) {
                this.setSelectedItem(null);
            } else {
                this.setSelectedItem(this.list.getRowAt(newIndex));
            }
        }
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.intervalRemoved(new ListDataEvent(this, 2, index, index));
        }
    }

    public void clearAndSetNew(List<E> newElements) {
        this.clearAndSetNew(newElements, false);
    }

    public void clearAndSetNew(List<E> newElements, boolean keepCurrent) {
        this.list.clearAndSetNew(newElements);
        int count = this.list.size();
        if (keepCurrent) {
            this.setSelectedItem(this.selectedItem);
        } else {
            this.setSelectedItem(null);
        }
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, Math.max(0, count - 1)));
        }
    }

    public void currentElementUpdated() {
        int index = ((List)this.list.getValue()).indexOf(this.selectedItem);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, index, index));
        }
    }

    public void valueChanged(int minSelectionIndex) {
        if (minSelectionIndex < 0) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(this.list.getRowAt(minSelectionIndex));
        }
    }
}

