/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.datacomparer.text;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;

public class LinePositionTracker {
    Position positionStart;
    Position positionEnd;
    int initialPositionIndex;
    int initialPositionIndexEnd;
    int adjustedIndex;
    int adjustedIndexEnd;
    boolean lineChanged = false;
    private DocumentListener listener;
    private Document document;

    public LinePositionTracker(Document d, int line) throws BadLocationException {
        this.document = d;
        Element defaultRootElement = d.getDefaultRootElement();
        boolean added = false;
        while (line >= defaultRootElement.getElementCount()) {
            d.insertString(defaultRootElement.getEndOffset(), "\n", null);
            added = true;
        }
        Element element = defaultRootElement.getElement(line);
        int index = element.getStartOffset();
        if (!added) {
            d.insertString(index, "\n", null);
        }
        element = defaultRootElement.getElement(line);
        this.positionStart = d.createPosition(index);
        this.positionEnd = d.createPosition(element.getEndOffset() - 1);
        this.adjustedIndex = this.initialPositionIndex = this.positionStart.getOffset();
        this.adjustedIndexEnd = this.initialPositionIndexEnd = this.positionEnd.getOffset();
        this.listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (LinePositionTracker.this.adjustedIndex == LinePositionTracker.this.positionStart.getOffset() && LinePositionTracker.this.adjustedIndexEnd == LinePositionTracker.this.positionEnd.getOffset()) {
                    return;
                }
                if (e.getOffset() + e.getLength() >= LinePositionTracker.this.adjustedIndex) {
                    LinePositionTracker.this.lineChanged = true;
                }
                LinePositionTracker.this.adjustedIndex = LinePositionTracker.this.positionStart.getOffset();
                LinePositionTracker.this.adjustedIndexEnd = LinePositionTracker.this.positionEnd.getOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (LinePositionTracker.this.adjustedIndex == LinePositionTracker.this.positionStart.getOffset() && LinePositionTracker.this.adjustedIndexEnd == LinePositionTracker.this.positionEnd.getOffset()) {
                    return;
                }
                if (e.getOffset() >= LinePositionTracker.this.adjustedIndex) {
                    LinePositionTracker.this.lineChanged = true;
                }
                LinePositionTracker.this.adjustedIndex = LinePositionTracker.this.positionStart.getOffset();
                LinePositionTracker.this.adjustedIndexEnd = LinePositionTracker.this.positionEnd.getOffset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        d.addDocumentListener(this.listener);
    }

    public String toString() {
        return "LinePositionTracker[lineChanged:" + this.lineChanged + ", position start: " + this.positionStart + ", position end: " + this.positionEnd + "]";
    }

    public void close() {
        this.document.removeDocumentListener(this.listener);
    }

    public boolean isLineChanged() {
        return this.lineChanged;
    }
}

