/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.datacomparer;

import com.siggemannen.datacomparer.DiffLineTracker;
import com.siggemannen.datacomparer.text.EditLineDetector;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class DiffTextMouseListener
extends MouseAdapter {
    private DiffLineTracker tracker;
    Map<JTextArea, Integer> mapIndex = new HashMap<JTextArea, Integer>();

    public DiffTextMouseListener(DiffLineTracker tracker) {
        this.tracker = tracker;
        for (int i = 0; i < tracker.getLineDetectors().size(); ++i) {
            EditLineDetector de = tracker.getLineDetectors().get(i);
            de.getArea().getArea().addMouseListener(this);
            this.mapIndex.put(de.getArea().getArea(), i);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() > 1) {
            JTextComponent jt = (JTextComponent)e.getComponent();
            int m = jt.viewToModel(e.getPoint());
            int line = jt.getDocument().getDefaultRootElement().getElementIndex(m);
            this.tracker.moveToDiffAtLine(line, this.mapIndex.get(jt));
            e.consume();
        } else if (e.getButton() == 1) {
            JTextComponent jt = (JTextComponent)e.getComponent();
            int m = jt.viewToModel(e.getPoint());
            int line = jt.getDocument().getDefaultRootElement().getElementIndex(m);
            this.tracker.removeHighlightsUnlessOnLineAlready(this.mapIndex.get(jt), line);
            e.consume();
        }
    }
}

